-- Anniversary Edition Setup v1.0
-- for Anniversary Edition Seven
-- by Iritscen
-- ***NOTE: Save as an application, then place Run AE Installer (built as an application too)
--	and AEsetuplogo.icns inside Contents/Resources/ folder of the Anniversary Edition Setup app.
--	Change the CFBundleIcon setting in the Setup app's Info.plist file to "AEsetuplogo" in order to
--	have the app use the icon.
-- For installing the Anniversary Edition Seven's AEI Updater. This script looks for an existing Oni
--	installation, places the AEInstaller2Updater into a new AE/ folder, and runs it. It also makes sure
--	that the user has Java installed so he can run the Updater and Installer.

global gSetupIcon
global gNeedsJavaVersionMajor
global gNeedsJavaVersionMinor

my main()

on main()
	--tell application "System Events"
	tell me
		activate
		set gSetupIcon to alias ((path to me as string) & "Contents:Resources:AEsetuplogo.icns")
		set gNeedsJavaVersionMajor to 1
		set gNeedsJavaVersionMinor to 6
		set installPath to ""
		set pathToMe to (path to me as string)
		display dialog ¬
			"Thanks for your interest in the fan-made Anniversary Edition (AE) of Oni.
	
This is the Setup application for the AE. Do not confuse this program with the \"AE Installer\", which will be found in the AE/ folder and which installs mods. This is a preliminary installation program.
	
Click OK, then locate your Oni installation to install the AE." buttons {"Quit", "OK"} default button 2 ¬
			with title "Anniversary Edition Setup" with icon gSetupIcon
		set OKorQuit to the button returned of the result
		if (OKorQuit is "OK") then
			set installPath to my find_Oni_folder()
			activate
			if (installPath is "") then
				display dialog "Sorry, the AE requires a retail Oni installation for it to work with." buttons {"Quit"} default button 1 with title "Anniversary Edition Setup" with icon gSetupIcon
			else
				set installResult to my install_AEI_Updater(installPath)
				activate
				if (installResult is 1) then
					display dialog "Could not install the AEI Updater because Java was not installed or new enough. The MacUpdate button may take you to the needed page. Otherwise, try the Java.com button." buttons {"MacUpdate", "Java.com", "Quit"} default button 3 with title "Anniversary Edition Setup" with icon gSetupIcon
					set quitMUOrJava to button returned of the result
					if (quitMUOrJava is "MacUpdate") then
						open location "http://www.macupdate.com/app/mac/39490/apple-java"
					else if (quitMUOrJava is "Java.com") then
						open location "http://www.java.com/getjava"
					end if
				else if (installResult is 2) then -- unknown failure (must be a file operation)
					display dialog "Could not install the AEI Updater. Please ask for help in the Anniversary Edition sub-forum of the Oni Central Forum." buttons {"Go to forum", "Quit"} default button 2 with title "Anniversary Edition Setup" with icon gSetupIcon
					set quitOrForum to button returned of the result
					if (quitOrForum is "Go to forum") then
						open location "http://oni.bungie.org/community/forum/index.php"
					end if
				else
					display dialog "Updater installed. AE Setup will now continue the installation by running the Updater." buttons {"OK"} default button 1 with title "Anniversary Edition Setup" with icon gSetupIcon
					set runResult to my run_AEIU(installPath)
					activate
					if (runResult is 1) then
						display dialog "Script copy error. Please ask for help in the Anniversary Edition sub-forum of the Oni Central Forum." buttons {"Go to forum", "Quit"} default button 2 with title "Anniversary Edition Setup" with icon gSetupIcon
						set quitOrForum to button returned of the result
						if (quitOrForum is "Go to forum") then
							open location "http://oni.bungie.org/community/forum/index.php"
						end if
					else if (runResult is 2) then
						display dialog "Could not run AEI Updater. Please ask for help in the Anniversary Edition sub-forum of the Oni Central Forum." buttons {"Go to forum", "Quit"} default button 2 with title "Anniversary Edition Setup" with icon gSetupIcon
						set quitOrForum to button returned of the result
						if (quitOrForum is "Go to forum") then
							open location "http://oni.bungie.org/community/forum/index.php"
						end if
					end if
				end if
			end if
		end if
	end tell
end main

-- The user must pick an acceptable folder to install the AE in, or die trying (or give up)
on find_Oni_folder()
	tell me
		activate
		set tryAgain to true
		set isOniRetail to false
		repeat while (tryAgain is true)
			set chosenPath to (choose folder with prompt "Please locate your Oni installation.")
			if (chosenPath is "") then
				display dialog "There was an error in choosing the Oni folder." buttons {"OK"} default button 1 with title "Anniversary Edition Setup" with icon gSetupIcon
				return chosenPath
			end if
			set folderTest to my validate_Oni_folder(chosenPath)
			activate
			if (folderTest is 1) then
				display dialog "This doesn't seem to be your Oni installation. Click \"Try again\" to locate another folder." buttons {"Quit", "Try again"} default button 2 with title "Anniversary Edition Setup" with icon gSetupIcon
				set quitOrTryAgain to the button returned of the result
				if (quitOrTryAgain is "Quit") then
					set tryAgain to false
				end if
			else if (folderTest is 2) then
				display dialog "This Oni installation already seems to have the AE installed! Click \"Try again\" to locate another folder." buttons {"Quit", "Try again"} default button 2 with title "Anniversary Edition Setup" with icon gSetupIcon
				set quitOrTryAgain to the button returned of the result
				if (quitOrTryAgain is "Quit") then
					set tryAgain to false
				end if
			else
				set tryAgain to false -- we got it, let's get out of this loop
			end if
		end repeat
		if (folderTest is 0) then
			return chosenPath
		else
			return ""
		end if
	end tell
end find_Oni_folder

-- Returns 0 if this is a valid target for the AE installation,
-- 1 if this is not a valid target, and
-- 2 if the AE is already here
on validate_Oni_folder(folderPath)
	tell application "Finder"
		activate
		-- Is the GDF here?
		if not (exists folder "GameDataFolder" in folder folderPath) then
			display dialog "GameDataFolder not detected here." buttons {"OK"} default button 1 with title "Anniversary Edition Setup" with icon gSetupIcon
			return 1
		end if
		-- Is the AE folder here? Because we won't install over it.
		if (exists folder "AE" in folder folderPath) then
			return 2
		end if
		
		-- Now see if this is the full installation or demo
		set retailLevelList to {0, 1, 2, 3, 4, 6, 8, 9, 10, 11, 12, 13, 14, 18, 19}
		set demoLevelList to {0, 1, 4} -- there's also a separate demo release of just level 2 to be dropped into the demo's GDF, but 1 and 4 were the only core demo levels
		set isRetail to true
		set isDemo to true
		-- Look for levels until one is missing and we know this isn't a complete retail release
		repeat with thisLevel in retailLevelList
			if not (exists file ((folderPath & "GameDataFolder:level" & thisLevel & "_Final.dat") as string)) then
				set isRetail to false
				exit repeat
			end if
		end repeat
		if (isRetail) then
			-- Don't return here if we add demo support below
			return 0
		end if
		-- Look for levels until one is missing and we know this isn't a complete demo release
		repeat with thisLevel in demoLevelList
			if not (exists file ((folderPath & "GameDataFolder:level" & thisLevel & "_Final.dat") as string)) then
				set isDemo to false
				exit repeat
			end if
		end repeat
		if (isDemo) then
			-- Insert handling of demo status here if we ever support a demo AE
			return 1
		else
			return 1
		end if
	end tell
end validate_Oni_folder

-- Check for an acceptable Java installation
-- This function was going to support a bundled JRE for those without Java,
-- but it adds too many complications, so just make the user install it himself
-- Returns 0 if the Updater was installed (which will install the Installer itself afterward),
-- 1 if Java is not found or too old, and
-- 2 if a file operation or other error occurs
on install_AEI_Updater(pathToOni)
	tell me
		-- See if we have Java
		set javaPath to ""
		try
			set javaPath to do shell script "which java"
		on error javaError -- "which" returns an error if the command is not found
			return 1
		end try
		if (javaPath is "") then -- safeguard, shouldn't happen
			return 1
		end if
		-- Now see what version it is
		set javaVersionCmd to ((javaPath & " -version 2>&1") as string) -- for some reason Java's version output is on stderr, not stdout :-/
		set javaVersionText to do shell script javaVersionCmd without altering line endings
		-- Isolate version number from output with format:
		(*	java version "1.7.0_17"
		Java(TM) SE Runtime Environment (build 1.7.0_17-b02)
		Java HotSpot(TM) 64-Bit Server VM (build 23.7-b01, mixed mode) *)
		set origDelimiters to text item delimiters
		-- Get first line
		set text item delimiters to "
"
		set javaVersionText to first text item of javaVersionText
		-- Get text after first quote mark
		set text item delimiters to "\""
		set javaVersionText to second text item of javaVersionText
		-- Get first and second version numbers, third doesn't matter
		set text item delimiters to "."
		set versionMajor to first text item of javaVersionText
		set versionMinor to second text item of javaVersionText
		set text item delimiters to origDelimiters
		-- Inform user if Java is too old
		if (versionMajor ≥ gNeedsJavaVersionMajor) then
			if (versionMinor < gNeedsJavaVersionMinor) then
				display dialog (("Sorry, Java v" & gNeedsJavaVersionMajor & "." & gNeedsJavaVersionMinor & " is required; found v" & versionMajor & "." & versionMinor & " instead.") as string) buttons {"OK"} default button 1 with title "Anniversary Edition Setup" with icon gSetupIcon
				return 1
			end if
		else
			return 1
		end if
	end tell
	-- Make "Oni/AE" folder
	tell application "Finder"
		if ((pathToOni & "AE") exists) then -- shouldn't happen because we already looked for it in validate_Oni_folder()
			return 2
		end if
		try
			make new folder at pathToOni with properties {name:"AE"}
			delay 0.5
			make new folder at ((pathToOni as string) & "AE") with properties {name:"AEInstaller"}
		on error
			display alert "Couldn't make AE or AEI folder!"
			return 2
		end try
		
		-- Copy AEI Updater into "AE/"
		set AEIU to ((path to me as string) & "Contents:Resources:AEInstaller2Updater.jar")
		set AEIfolder to (pathToOni & "AE:AEInstaller" as string)
		try
			duplicate file AEIU to folder AEIfolder
		on error copyError
			return 2
		end try
	end tell
	return 0
end install_AEI_Updater

-- Drops an applet into the new "AE/" folder and runs it;
-- the applet will try to run the AEI, but if it's not found,
-- it runs the AEI Updater, which is what we want to happen
-- so that the AEI can be installed.
-- Returns 0 if this is a valid target for the AE installation,
-- 1 if the applet cannot be dropped, and
-- 2 if the applet cannot be run
on run_AEIU(pathToOni)
	tell application "Finder"
		-- Copy applet to AE/ that opens AEI or AEIU if AEI is not around
		set RAEI to ((path to me as string) & "Contents:Resources:Run AE Installer.app")
		set pathToAE to alias ((pathToOni & "AE") as string)
		try
			duplicate RAEI to pathToAE
		on error copyError
			return 1
		end try
		set RAEI to ((pathToAE as string) & "Run AE Installer.app")
		try
			open RAEI
		on error runError
			return 2
		end try
	end tell
	return 0
end run_AEIU